unit DataModule;

interface

uses
  SysUtils, Classes, DB, DBTables, Dialogs, Forms;

type
  TDM = class(TDataModule)
    Database1: TDatabase;
    TableWydawnictwa: TTable;
    dsWydawnictwa: TDataSource;
    TableWydawnictwaIDWYDAW: TAutoIncField;
    TableWydawnictwaNAZWA: TStringField;
    TableWydawnictwaULICAINR: TStringField;
    TableWydawnictwaKODP: TStringField;
    TableWydawnictwaMIASTO: TStringField;
    TableWydawnictwaTEL: TStringField;
    TableWydawnictwaFAX: TStringField;
    TableWydawnictwaEMAIL: TStringField;
    TableWydawnictwaWWW: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private

  public

  end;

var
  DM: TDM;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}

procedure TDM.DataModuleCreate(Sender: TObject);
var
   isOK  : Boolean;
   tresc : String;

begin
   isOK := true;

   try
      Database1.Connected := true;
   except
      on e : EDatabaseError do
      begin
         {
         ShowMessage(e.Message);
         }
         isOK  := false;
         tresc := AnsiLowerCase(e.Message);

         if (Pos('sterownik ODBC', tresc) > 0) or
            (Pos('nieznane', tresc) > 0) or
            (Pos('SprAccess', tresc) > 0) then
         begin
            ShowMessage('Tworzenie poczenia ODBC jest treci lekcji - zdefinuj Alias: "Sprawdzamy ODBC dla MS Access" na podstawie rozdziau 14');
         end;
      end;
   end;

   if isOK then
   begin
      TableWydawnictwa.Open();
   end
   else begin
      Application.Terminate();
   end;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   TableWydawnictwa.Close();
   Database1.Connected := false;
end;

end.
